//
//  MCStackResultsHeader.h
//  MCApplication
//
//  Created by Ali Lalani on 8/27/04.
//  Copyright 2004 Marketcircle Inc. All rights reserved.
//

#import "MCStackTabbedHeader.h"
#import <MCFoundation/MCSourceList.h>

@interface MCStackResultsHeader : MCStackTabbedHeader {
	NSString *displayString;
	NSDictionary *displayStringAttributes;
	NSAttributedString *attributedDisplayString;

	NSProgressIndicator *progressIndicator;
	NSSearchField       *searchField;
	
	// BINDINGS STUFF //
	int numberOfResults;
	NSIndexSet *resultsSelection;
	
	NSMutableDictionary *observerDictionary;
	
	NSRect displayStringRect;
	NSRect leftArrowRect;
	NSRect rightArrowRect;
	NSRect searchFieldRect;
	
	NSTrackingRectTag 	rightArrowTrackingRectTag;
	NSTrackingRectTag   leftArrowTrackingRectTag;
	BOOL mouseDownInRightArrow;
	BOOL mouseDownInLeftArrow;
	BOOL mouseOverInRightArrow;
	BOOL mouseOverInLeftArrow;
	BOOL rightArrowActive;
	BOOL leftArrowActive;

	BOOL isDualPane; // if there's only two tabs, double and single
	BOOL hasSearchField;
}
- (void)addTabForBrowseView;
- (void)configureDisplayString;
- (void)selectNext;
- (void)selectPrevious;
- (void)sourceListEdited:(NSNotification *)aNotification;
- (void)setupBindings;

- (void)updateHeader;
- (void)updateNumberOfResults;
- (void)updateResultsSelection;
- (void)updateArrows;

- (void)setupSearchField;

// deprecated, progress is now displayed in the main window status bar at the bottom
//- (void)setupProgressIndicator; 
// deprecated, progress is now displayed in the main window status bar at the bottom
//- (void)stopProgressIndicator;
// deprecated, progress is now displayed in the main window status bar at the bottom
//- (void)startProgressIndicator;

//////////////////////////// ACCESSORS //////////////////////////////
- (NSString *)displayString;
- (void)setDisplayString:(NSString *)aDisplayString;
- (NSDictionary *)displayStringAttributes;
- (void)setDisplayStringAttributes:(NSDictionary *)aDisplayStringAttributes;
- (NSAttributedString *)attributedDisplayString;
- (void)setAttributedDisplayString:(NSAttributedString *)anAttributedDisplayString;
- (NSArray *)sourceLists;
- (BOOL)isDualPane;
- (void)setIsDualPane:(BOOL)flag;
- (NSProgressIndicator *)progressIndicator;
- (void)setProgressIndicator:(NSProgressIndicator *)aProgressIndicator;

- (BOOL)hasSearchField;
- (void)setHasSearchField:(BOOL)flag;
- (NSSearchField *)searchField;
- (void)setSearchField:(NSSearchField *)aSearchField;

////////////////////////// BINDINGS ACCESSORS //////////////////////
- (int)numberOfResults;
- (void)setNumberOfResults:(int)aNumberOfResults;
- (NSIndexSet *)resultsSelection;
- (void)setResultsSelection:(NSIndexSet *)aResultsSelection;

@end
